/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.player;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.KeyPressEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.MouseEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BindSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.utility.game.ItemUtility;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.inventory.ItemSlot;
import Krasnodar.rockstarnew.utility.inventory.group.SlotGroup;
import Krasnodar.rockstarnew.utility.inventory.group.SlotGroups;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_7225;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@ModuleInfo(name="Swap", category=ModuleCategory.PLAYER)
public class Swap
extends BaseModule {
    private final BindSetting wheelBind = new BindSetting(this, "modules.settings.swap.wheel_bind");
    private final SelectSetting show = new SelectSetting(this, "modules.settings.swap.show");
    private final SelectSetting.Value showTotems = new SelectSetting.Value(this.show, "modules.settings.swap.show.totems").select();
    private final SelectSetting.Value showHeads = new SelectSetting.Value(this.show, "modules.settings.swap.show.heads").select();
    private boolean wheelOpen;
    private boolean cursorUnlocked;
    private List<WheelEntry> wheelEntries = List.of();
    private final EventListener<KeyPressEvent> onKey = event -> {
        if (event.getAction() != 1) {
            return;
        }
        if (Swap.mc.field_1755 != null) {
            return;
        }
        if (this.wheelBind.isKey(event.getKey())) {
            this.toggleWheel();
        }
    };
    private final EventListener<MouseEvent> onMouse = event -> {
        if (Swap.mc.field_1755 != null) {
            return;
        }
        if (this.wheelBind.isKey(event.getButton())) {
            this.toggleWheel();
            return;
        }
        if (!this.wheelOpen || Swap.mc.field_1755 != null) {
            return;
        }
        if (event.getButton() == 0) {
            this.pickWheelSlot();
        }
        if (event.getButton() == 1) {
            this.toggleWheel();
        }
    };
    private final EventListener<HudRenderEvent> onHud = event -> {
        int i;
        if (!this.wheelOpen) {
            return;
        }
        if (Swap.mc.field_1755 != null) {
            this.wheelOpen = false;
            this.updateWheelCursorState(false);
            return;
        }
        this.wheelEntries = this.buildWheelEntries();
        this.updateWheelCursorState(true);
        int count = Math.max(3, this.wheelEntries.size());
        float cx = sr.getScaledWidth() / 2.0f;
        float cy = sr.getScaledHeight() / 2.0f;
        float outerR = 92.0f + (float)Math.max(0, count - 8) * 6.0f;
        float innerR = Math.max(26.0f, outerR - 38.0f);
        float mouseX = GuiUtility.getMouse().method_32118();
        float mouseY = GuiUtility.getMouse().method_32119();
        int hover = this.getHoverIndex(mouseX, mouseY, cx, cy, innerR, outerR, count);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        Matrix4f matrix = event.getContext().method_51448().method_23760().method_23761();
        class_287 buffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        for (i = 0; i < count; ++i) {
            boolean isHover = i == hover;
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 200;
            if (isHover) {
                r = 255;
                g = 209;
                b = 47;
                a = 200;
            }
            float start = (float)(-1.5707963267948966 + Math.PI * 2 * ((double)i / (double)count));
            float end = (float)(-1.5707963267948966 + Math.PI * 2 * (((double)i + 1.0) / (double)count));
            this.drawRingSegment(buffer, matrix, cx, cy, innerR, outerR, start, end, r, g, b, a);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
        for (i = 0; i < count; ++i) {
            WheelEntry entry;
            float start = (float)(-1.5707963267948966 + Math.PI * 2 * ((double)i / (double)count));
            float end = (float)(-1.5707963267948966 + Math.PI * 2 * (((double)i + 1.0) / (double)count));
            WheelEntry wheelEntry = entry = i < this.wheelEntries.size() ? this.wheelEntries.get(i) : null;
            if (entry == null) continue;
            float mid = (start + end) / 2.0f;
            float iconR = (innerR + outerR) / 2.0f;
            float ix = cx + (float)Math.cos(mid) * iconR;
            float iy = cy + (float)Math.sin(mid) * iconR;
            event.getContext().method_51427(entry.displayStack, (int)(ix - 8.0f), (int)(iy - 8.0f));
            if (entry.totalCount <= 1) continue;
            event.getContext().method_25303(Swap.mc.field_1772, String.valueOf(entry.totalCount), (int)(ix + 5.0f), (int)(iy + 3.0f), 0xFFFFFF);
        }
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        if (hover >= 0 && hover < this.wheelEntries.size()) {
            WheelEntry entry = this.wheelEntries.get(hover);
            event.getContext().method_27535(Swap.mc.field_1772, entry.displayStack.method_7964(), (int)(mouseX + 10.0f), (int)(mouseY + 10.0f), 0xFFFFFF);
        }
    };

    @Override
    public void onDisable() {
        this.wheelOpen = false;
        this.updateWheelCursorState(false);
        super.onDisable();
    }

    private void toggleWheel() {
        boolean bl = this.wheelOpen = !this.wheelOpen;
        if (!this.wheelOpen) {
            this.updateWheelCursorState(false);
            return;
        }
        this.updateWheelCursorState(true);
    }

    private void updateWheelCursorState(boolean shouldBeUnlocked) {
        if (mc == null || Swap.mc.field_1729 == null) {
            return;
        }
        if (shouldBeUnlocked) {
            if (!this.cursorUnlocked) {
                Swap.mc.field_1729.method_1610();
                this.cursorUnlocked = true;
            }
            return;
        }
        if (this.cursorUnlocked) {
            if (Swap.mc.field_1755 == null) {
                Swap.mc.field_1729.method_1612();
            }
            this.cursorUnlocked = false;
        }
    }

    private void pickWheelSlot() {
        float mouseY;
        int count = Math.max(3, this.wheelEntries.size());
        float cx = sr.getScaledWidth() / 2.0f;
        float cy = sr.getScaledHeight() / 2.0f;
        float outerR = 92.0f + (float)Math.max(0, count - 8) * 6.0f;
        float innerR = Math.max(26.0f, outerR - 38.0f);
        float mouseX = GuiUtility.getMouse().method_32118();
        int hover = this.getHoverIndex(mouseX, mouseY = GuiUtility.getMouse().method_32119(), cx, cy, innerR, outerR, count);
        if (hover == -1) {
            this.toggleWheel();
            return;
        }
        if (hover >= this.wheelEntries.size()) {
            this.toggleWheel();
            return;
        }
        WheelEntry entry = this.wheelEntries.get(hover);
        ItemSlot slot = this.findBestSlot(entry.predicate);
        if (slot == null) {
            this.toggleWheel();
            return;
        }
        this.moveToOffhand(slot);
        this.toggleWheel();
    }

    private void moveToOffhand(ItemSlot slot) {
        if (Swap.mc.field_1724 == null) {
            return;
        }
        if (slot.getIdForServer() == 45) {
            return;
        }
        if (Swap.mc.field_1761 == null || Swap.mc.field_1724.field_7512 == null) {
            return;
        }
        Swap.mc.field_1761.method_2906(Swap.mc.field_1724.field_7512.field_7763, slot.getIdForServer(), 40, class_1713.field_7791, (class_1657)Swap.mc.field_1724);
    }

    private ItemSlot findBestSlot(class_1792 item) {
        if (item == null || item == class_1802.field_8162) {
            return null;
        }
        SlotGroup<ItemSlot> slotsToSearch = SlotGroups.inventory().and(SlotGroups.hotbar());
        List<ItemSlot> slots = slotsToSearch.findItems(item);
        return slots.stream().min(Comparator.comparingInt(this::bestFactorForSwap)).orElse(null);
    }

    private ItemSlot findBestSlot(Predicate<class_1799> predicate) {
        if (predicate == null) {
            return null;
        }
        SlotGroup<ItemSlot> slotsToSearch = SlotGroups.inventory().and(SlotGroups.hotbar());
        List<ItemSlot> slots = slotsToSearch.findItems(predicate);
        return slots.stream().min(Comparator.comparingInt(this::bestFactorForSwap)).orElse(null);
    }

    private int bestFactorForSwap(ItemSlot slot) {
        return ItemUtility.bestFactor(slot.itemStack()) - (slot.getIdForServer() == 45 ? 99 : 0);
    }

    private List<WheelEntry> buildWheelEntries() {
        if (Swap.mc.field_1724 == null || Swap.mc.field_1687 == null) {
            return List.of();
        }
        SlotGroup<ItemSlot> group = SlotGroups.inventory().and(SlotGroups.hotbar()).and(SlotGroups.offhand());
        List<ItemSlot> slots = group.getSlots();
        HashMap<String, WheelEntryAccum> accum = new HashMap<String, WheelEntryAccum>();
        ArrayList<WheelEntry> result = new ArrayList<WheelEntry>();
        for (ItemSlot slot : slots) {
            String key;
            class_1799 display;
            class_1799 stack = slot.itemStack();
            if (stack == null || stack.method_7960() || stack.method_7909() == class_1802.field_8162) continue;
            if (this.showTotems.isSelected() && stack.method_7909() == class_1802.field_8288) {
                if (this.isNormalTotem(stack)) {
                    String key2 = "totem:normal";
                    WheelEntryAccum entry = accum.computeIfAbsent(key2, k -> new WheelEntryAccum(stack.method_46651(1), 0, s -> s.method_7909() == class_1802.field_8288 && this.isNormalTotem((class_1799)s)));
                    entry.totalCount += stack.method_7947();
                } else {
                    display = stack.method_46651(1);
                    key = "totem:enchanted:" + this.stackKey(display);
                    result.add(new WheelEntry(display, stack.method_7947(), s -> s.method_7909() == class_1802.field_8288 && !this.isNormalTotem((class_1799)s) && this.stackKey((class_1799)s).equals(this.stackKey(display)), key));
                }
            }
            if (!this.showHeads.isSelected() || stack.method_7909() != class_1802.field_8575) continue;
            display = stack.method_46651(1);
            key = "head:" + this.stackKey(display);
            WheelEntryAccum entry = accum.computeIfAbsent(key, k -> new WheelEntryAccum(display, 0, s -> s.method_7909() == class_1802.field_8575 && this.stackKey((class_1799)s).equals(this.stackKey(display))));
            entry.totalCount += stack.method_7947();
        }
        for (WheelEntryAccum entry : accum.values()) {
            result.add(new WheelEntry(entry.displayStack, entry.totalCount, entry.predicate, "accum"));
        }
        result.sort(Comparator.comparingInt(e -> e.displayStack.method_7909() == class_1802.field_8288 ? 0 : 1));
        return result;
    }

    private boolean isNormalTotem(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8288 && !stack.method_7942() && !ItemUtility.isDonItem(stack);
    }

    private String stackKey(class_1799 stack) {
        if (Swap.mc.field_1687 == null) {
            return stack.method_7909().toString();
        }
        class_1799 copy = stack.method_46651(1);
        try {
            class_2520 nbt = copy.method_57375((class_7225.class_7874)Swap.mc.field_1687.method_30349());
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                compound.method_10551("count");
                return compound.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return copy.method_7909().toString() + "|" + String.valueOf(copy.method_57353());
    }

    private int getHoverIndex(float mouseX, float mouseY, float cx, float cy, float innerR, float outerR, int count) {
        int idx;
        float dx = mouseX - cx;
        float dy = mouseY - cy;
        float dist = (float)Math.sqrt(dx * dx + dy * dy);
        if (dist < innerR || dist > outerR) {
            return -1;
        }
        double ang = Math.atan2(dy, dx);
        if ((ang += 1.5707963267948966) < 0.0) {
            ang += Math.PI * 2;
        }
        if ((idx = (int)Math.floor(ang / (Math.PI * 2) * (double)count)) < 0 || idx >= count) {
            return -1;
        }
        return idx;
    }

    private void drawRingSegment(class_287 buffer, Matrix4f matrix, float cx, float cy, float innerR, float outerR, float start, float end, int r, int g, int b, int a) {
        int steps = Math.max(10, (int)(48.0f * (Math.abs(end - start) / ((float)Math.PI * 2))));
        float step = (end - start) / (float)steps;
        for (int i = 0; i < steps; ++i) {
            float a0 = start + step * (float)i;
            float a1 = start + step * (float)(i + 1);
            float x0o = cx + (float)Math.cos(a0) * outerR;
            float y0o = cy + (float)Math.sin(a0) * outerR;
            float x1o = cx + (float)Math.cos(a1) * outerR;
            float y1o = cy + (float)Math.sin(a1) * outerR;
            float x0i = cx + (float)Math.cos(a0) * innerR;
            float y0i = cy + (float)Math.sin(a0) * innerR;
            float x1i = cx + (float)Math.cos(a1) * innerR;
            float y1i = cy + (float)Math.sin(a1) * innerR;
            buffer.method_22918(matrix, x0i, y0i, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, x0o, y0o, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, x1o, y1o, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, x0i, y0i, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, x1o, y1o, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, x1i, y1i, 0.0f).method_1336(r, g, b, a);
        }
    }

    private static class WheelEntry {
        final class_1799 displayStack;
        final int totalCount;
        final Predicate<class_1799> predicate;
        final String debugKey;

        WheelEntry(class_1799 displayStack, int totalCount, Predicate<class_1799> predicate, String debugKey) {
            this.displayStack = displayStack;
            this.totalCount = totalCount;
            this.predicate = predicate;
            this.debugKey = debugKey;
        }
    }

    private static class WheelEntryAccum {
        final class_1799 displayStack;
        int totalCount;
        final Predicate<class_1799> predicate;

        WheelEntryAccum(class_1799 displayStack, int totalCount, Predicate<class_1799> predicate) {
            this.displayStack = displayStack;
            this.totalCount = totalCount;
            this.predicate = predicate;
        }
    }
}

